#!/bin/sh

MASTER_PAGE_LOG_CONF_RESULT_MSG=""
MASTER_PAGE_LOG_CONF_RESULT_OK=0
MASTER_PAGE_LOG_CONF_RESULT_ERROR=1

MASTER_PAGE_LOG_CONF_RESULT_CODE=${MASTER_PAGE_LOG_CONF_RESULT_ERROR}
MASTER_PAGE_LOG_CONF_RESULT_ROLLING=0

collect_log()
{
	# redirect to sboxcmd
	local result=`/opt/TrendMicro/DTAS/ManagementServer/bin/sboxcmd/sboxcmd debug get-debug-logpath`
	local is_success=`echo "${result}" | grep '"return_code":"0"'`
	if [ "${is_success}" == "" ]; then
		
		# delete all redundant '\' and extract message
		local message=`echo "${result//\\\\/}" | cut -d"," -f 2`
		
		# delete all redundant '"'
		message="${message//\"/}"
		
		warning "${DEBUG_STRING_FAIL_TO_COLLECT_DEBUGLOG}" "${message}"
		return 1
	fi

	# delete all redundant '\' and extract url
	local url=`echo "${result//\\\\/}" | cut -d"," -f 3`
	
	# delete all redundant '"'
	url="${url//\"/}"
	
	# delete 'url:'
	url="${url#url:}"
	
	warning "${MASTER_PAGE_LOG_CONF_DEBUGLOG_FILE_AVAILABLE_AT}" "${url}"
}

master_page_log_conf() 
{
	debug_print "${0}" "${LINENO}" 'in function "master_page_log_conf"'

	local item_number=2
	local menu_list=""
	for (( i=1; i<=$item_number; i=i+1 ))
	do
			eval menu_item=\$MASTER_PAGE_LOG_CONF_ITEM_$i
			menu_list="$menu_list$i \"$menu_item\" "
	done

	tp_menu_ok_cancel \
	"${MASTER_PAGE_LOG_CONF_TITLE}" \
	"${MASTER_PAGE_LOG_CONF_TEXT}" \
	"${MASTER_PAGE_LOG_CONF_LABEL_OK}" \
	"${MASTER_PAGE_LOG_CONF_LABEL_CANCEL}" \
	"$menu_list" \
	$item_number

	# no error cases
	MASTER_PAGE_LOG_CONF_RESULT_CODE=${MASTER_PAGE_LOG_CONF_RESULT_OK}
	if [ "${TP_MENU_OK_CANCEL_RESULT_CODE}" == "${TP_MENU_OK_CANCEL_RESULT_CANCEL}" ]; then
		MASTER_PAGE_LOG_CONF_RESULT_ROLLING=-1
		return
	fi
	
	# result_code = ok
	case ${TP_MENU_OK_CANCEL_RESULT_SELECT} in
		1) # choose 'Configure logs'
			MASTER_PAGE_LOG_CONF_RESULT_ROLLING=1
			;; 
		2) # choose 'Collect logs'
			collect_log 
			MASTER_PAGE_LOG_CONF_RESULT_ROLLING=-1
			;; 
		*) ;;
	esac
}
